/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.sync.impl;

import com.alibaba.fastjson.JSONObject;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.Signer;
import com.valor.common.search.engine.util.CollectionUtils;
import com.valor.common.search.engine.util.SearchUtils;
import com.valor.common.search.engine.util.StringUtils;
import com.valor.common.search.sync.SearchSyncConfig;
import com.valor.common.search.sync.SearchSyncException;
import com.valor.common.search.sync.impl.AWSRequestSigningApacheInterceptor;
import com.valor.common.search.sync.impl.DefaultSearchSyncConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;

public class DefaultSearchSync {
    private static RestHighLevelClient elasticSearchClient;
    public static final String DEFAULT_B_TYPE = "peliplat";
    private static final String CONFIG_FILE = "/search-sync.properties";
    private static SearchSyncConfig defaultSearchApiConfig;

    public static void init() {
        DefaultSearchSync.initInternal(defaultSearchApiConfig);
    }

    public static void init(String host, int port, String username, String pwd) {
        defaultSearchApiConfig.setHost(host);
        defaultSearchApiConfig.setPassword(pwd);
        defaultSearchApiConfig.setPort(port);
        defaultSearchApiConfig.setUsername(username);
        DefaultSearchSync.initInternal(defaultSearchApiConfig);
    }

    public static void init(String host, int port) {
        DefaultSearchSync.init(host, port, null, null);
    }

    private static void initInternal(SearchSyncConfig searchApiConfig) {
        RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(searchApiConfig.getHost(), searchApiConfig.getPort(), "http")});
        if (searchApiConfig.getUsername() != null && searchApiConfig.getPassword() != null) {
            AWS4Signer signer = new AWS4Signer();
            signer.setServiceName("es");
            signer.setRegionName("us-east-2");
            BasicAWSCredentials awsCreds = new BasicAWSCredentials(searchApiConfig.getUsername(), searchApiConfig.getPassword());
            AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCreds);
            AWSRequestSigningApacheInterceptor interceptor = new AWSRequestSigningApacheInterceptor("es", (Signer)signer, (AWSCredentialsProvider)awsCredentialsProvider);
            clientBuilder.setHttpClientConfigCallback(f -> f.addInterceptorLast(interceptor));
        }
        elasticSearchClient = new RestHighLevelClient(clientBuilder);
    }

    public static Map<Long, String> save(List<String> jsonDataList) throws SearchSyncException {
        return DefaultSearchSync.batchSave(defaultSearchApiConfig.getIndexName(), defaultSearchApiConfig.getIndexType(), jsonDataList);
    }

    private static Map<Long, String> batchSave(String index, String type, List<String> contentList) throws SearchSyncException {
        List insertList;
        long page = 1L;
        long pageSize = 1000L;
        long saveCount = 0L;
        if (CollectionUtils.isEmpty(contentList)) {
            throw new SearchSyncException("Parameter contentList must not empty.");
        }
        HashMap<Long, String> faildIndexList = new HashMap<Long, String>();
        while (!CollectionUtils.isEmpty(insertList = contentList.stream().skip((page - 1L) * pageSize).limit(pageSize).collect(Collectors.toList()))) {
            BulkRequest bulkRequest = new BulkRequest();
            List<String> copyFromFields = defaultSearchApiConfig.getMainIndicSourceFieldsName();
            long fromIndex = (page - 1L) * pageSize;
            ArrayList<Long> submitIndexList = new ArrayList<Long>();
            for (int i = 0; i < insertList.size(); ++i) {
                String content = (String)insertList.get(i);
                BulkItemResponse[] mainTitleValues = new ArrayList();
                Map objValues = (Map)JSONObject.parseObject((String)content, Map.class);
                for (String fieldName : copyFromFields) {
                    Object fieldValue = objValues.get(fieldName);
                    if (fieldValue != null && fieldValue instanceof List) {
                        List tempList = (List)fieldValue;
                        if (CollectionUtils.isEmpty((Collection)tempList)) continue;
                        mainTitleValues.addAll(tempList);
                        continue;
                    }
                    if (fieldValue == null || !(fieldValue instanceof String) || StringUtils.isEmpty((Object)fieldValue.toString())) continue;
                    mainTitleValues.add(fieldValue);
                }
                objValues.put(defaultSearchApiConfig.getMatchMainIndicFieldName(), mainTitleValues);
                if (objValues.get(defaultSearchApiConfig.getDocumentIdentifyFieldName()) == null || StringUtils.isEmpty((Object)objValues.get(defaultSearchApiConfig.getDocumentIdentifyFieldName()).toString())) {
                    faildIndexList.put(fromIndex + (long)i, "docId is empty");
                    continue;
                }
                submitIndexList.add(fromIndex + (long)i);
                String id = objValues.get(defaultSearchApiConfig.getDocumentIdentifyFieldName()).toString();
                String targetJson = JSONObject.toJSONString((Object)objValues);
                IndexRequest indexRequest = new IndexRequest(index, type, id);
                indexRequest.source(targetJson, XContentType.JSON);
                bulkRequest.add(indexRequest);
            }
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            try {
                BulkResponse response = SearchUtils.bulk((RestHighLevelClient)elasticSearchClient, (BulkRequest)bulkRequest);
                int k = 0;
                for (BulkItemResponse resp : response.getItems()) {
                    if (resp.getOpType().equals((Object)DocWriteRequest.OpType.INDEX)) {
                        if (resp.isFailed()) {
                            faildIndexList.put((Long)submitIndexList.get(k), resp.getFailureMessage());
                        } else if (resp.getResponse().getResult().equals((Object)DocWriteResponse.Result.CREATED) || resp.getResponse().getResult().equals((Object)DocWriteResponse.Result.UPDATED)) {
                            ++saveCount;
                        } else {
                            faildIndexList.put((Long)submitIndexList.get(k), "docment not created or updated,but " + resp.getResponse().getResult().getLowercase());
                        }
                    }
                    ++k;
                }
            }
            catch (Exception e) {
                for (Long n : submitIndexList) {
                    faildIndexList.put(n, "Cause by :" + e.getMessage());
                }
                throw new SearchSyncException(e);
            }
            ++page;
        }
        return faildIndexList;
    }

    public static long deleteById(String id) throws SearchSyncException {
        if (StringUtils.isEmpty((Object)id)) {
            throw new SearchSyncException("id must not empty.");
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        return DefaultSearchSync.deleteByIds(ids);
    }

    public static long deleteByIds(List<String> ids) throws SearchSyncException {
        List subIdsList;
        if (StringUtils.isEmpty(ids)) {
            throw new SearchSyncException("id must not empty.");
        }
        long page = 1L;
        long pageSize = 1000L;
        long deletedCount = 0L;
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        while (!CollectionUtils.isEmpty(subIdsList = ids.stream().skip((page - 1L) * pageSize).limit(pageSize).collect(Collectors.toList()))) {
            for (String id : subIdsList) {
                DeleteRequest delete = new DeleteRequest();
                delete.index(defaultSearchApiConfig.getIndexName());
                delete.type(defaultSearchApiConfig.getIndexType());
                delete.id(id);
                bulkRequest.add(delete);
            }
            try {
                BulkResponse bulkResponse = elasticSearchClient.bulk(bulkRequest, new Header[0]);
                for (BulkItemResponse response : bulkResponse.getItems()) {
                    try {
                        if (!response.getResponse().getResult().equals((Object)DocWriteResponse.Result.DELETED)) continue;
                        ++deletedCount;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                throw new SearchSyncException(e);
            }
            ++page;
        }
        return deletedCount;
    }

    public static long updateById(String jsonData) throws SearchSyncException {
        if (StringUtils.isEmpty((Object)jsonData)) {
            throw new SearchSyncException("Parameter jsonData must not empty.");
        }
        ArrayList<String> jsonDataList = new ArrayList<String>();
        jsonDataList.add(jsonData);
        return DefaultSearchSync.updateByIds(jsonDataList);
    }

    public static long updateByIds(List<String> jsonDataList) throws SearchSyncException {
        List subUpdateDataList;
        long page = 1L;
        long pageSize = 1000L;
        long upodateCount = 0L;
        if (CollectionUtils.isEmpty(jsonDataList)) {
            throw new SearchSyncException("Parameter jsonDataList must not empty.");
        }
        while (!CollectionUtils.isEmpty(subUpdateDataList = jsonDataList.stream().skip((page - 1L) * pageSize).limit(pageSize).collect(Collectors.toList()))) {
            BulkRequest bulkRequest = new BulkRequest();
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            List<String> copyFromFields = defaultSearchApiConfig.getMainIndicSourceFieldsName();
            for (String jsonData : subUpdateDataList) {
                ArrayList mainTitleValues = new ArrayList();
                Map objValues = (Map)JSONObject.parseObject((String)jsonData, Map.class);
                if (objValues.get(defaultSearchApiConfig.getDocumentIdentifyFieldName()) == null || StringUtils.isEmpty((Object)objValues.get(defaultSearchApiConfig.getDocumentIdentifyFieldName()).toString())) continue;
                for (String fieldName : copyFromFields) {
                    Object fieldValue = objValues.get(fieldName);
                    if (fieldValue != null && fieldValue instanceof List) {
                        List tempList = (List)fieldValue;
                        if (CollectionUtils.isEmpty((Collection)tempList)) continue;
                        mainTitleValues.addAll(tempList);
                        continue;
                    }
                    if (fieldValue == null || !(fieldValue instanceof String) || StringUtils.isEmpty((Object)fieldValue.toString())) continue;
                    mainTitleValues.add(fieldValue);
                }
                objValues.put(defaultSearchApiConfig.getMatchMainIndicFieldName(), mainTitleValues);
                String targetJson = JSONObject.toJSONString((Object)objValues);
                UpdateRequest updateRequest = new UpdateRequest();
                ((UpdateRequest)updateRequest.doc(targetJson, XContentType.JSON).index(defaultSearchApiConfig.getIndexName())).id(objValues.get(defaultSearchApiConfig.getDocumentIdentifyFieldName()).toString()).type(defaultSearchApiConfig.getIndexType());
                bulkRequest.add(updateRequest);
            }
            try {
                BulkResponse bulkResponse = SearchUtils.bulk((RestHighLevelClient)elasticSearchClient, (BulkRequest)bulkRequest);
                for (BulkItemResponse itemResponse : bulkResponse.getItems()) {
                    try {
                        if (!itemResponse.getResponse().getResult().equals((Object)DocWriteResponse.Result.UPDATED)) continue;
                        ++upodateCount;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                throw new SearchSyncException(e);
            }
            ++page;
        }
        return upodateCount;
    }

    public static SearchSyncConfig getDefaultSearchSyncConfig() {
        return defaultSearchApiConfig;
    }

    static {
        try {
            defaultSearchApiConfig = DefaultSearchSyncConfig.initFromConfig(CONFIG_FILE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load search-sync configuration /search-sync.properties", e);
        }
    }
}

