/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.sync;

import com.alibaba.fastjson.JSONObject;
import com.valor.common.search.sync.SearchSyncConfig;
import com.valor.common.search.sync.SearchSyncException;
import com.valor.common.search.sync.impl.DefaultSearchSync;
import com.valor.common.search.sync.model.IndexInData;
import com.valor.common.search.sync.utils.CollectionUtils;
import com.valor.common.search.sync.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public final class SearchSync {
    private static Logger logger = LoggerFactory.getLogger(SearchSync.class);

    public SearchSync() {
        DefaultSearchSync.init();
    }

    public SearchSync(String host, int port) {
        DefaultSearchSync.init(host, port);
    }

    public SearchSync(String host, int port, String username, String password) {
        DefaultSearchSync.init(host, port, username, password);
    }

    public Map<Long, String> save(List<IndexInData> indexInDataList) {
        if (CollectionUtils.isEmpty(indexInDataList)) {
            throw new SearchSyncException("Parameter indexInDataList  must not empty.");
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        ArrayList<String> jsonDataList = new ArrayList<String>();
        indexInDataList.stream().filter(a -> a != null).collect(Collectors.toList()).stream().forEachOrdered(idxData -> {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariable("obj", idxData.getExtIndexObject());
            String spelPrefix = "#obj.";
            Properties prop = this.getSearchSyncConfig().getExtFieldToIndexProps();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("title", idxData.getTitle());
            jsonObject.put("keywords", idxData.getKeywords());
            jsonObject.put("mark", (Object)idxData.getMark());
            jsonObject.put("weight", (Object)idxData.getWeight());
            jsonObject.put("bType", (Object)idxData.getbType());
            jsonObject.put("docId", (Object)idxData.getDocId());
            jsonObject.put("data", (Object)idxData.getData());
            for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                try {
                    String spel = spelPrefix + entry.getValue();
                    Expression expr = parser.parseExpression(spel);
                    Object res = expr.getValue((EvaluationContext)context);
                    if (res == null) continue;
                    jsonObject.put((String)entry.getKey(), (Object)res.toString());
                }
                catch (Exception e) {
                    logger.error("Parse docId  {}  field '{}' failed  error msg :", new Object[]{idxData.getDocId(), entry.getValue(), e.getMessage()});
                }
            }
            jsonDataList.add(jsonObject.toJSONString());
        });
        return DefaultSearchSync.save(jsonDataList);
    }

    public long deleteById(String id) {
        if (StringUtils.isEmpty(id)) {
            throw new SearchSyncException("Parameter id must not null.");
        }
        return DefaultSearchSync.deleteById(id);
    }

    public long deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new SearchSyncException("Parameter ids must not null.");
        }
        ids = ids.stream().filter(a -> !StringUtils.isEmpty(a)).collect(Collectors.toList());
        return DefaultSearchSync.deleteByIds(ids);
    }

    public SearchSyncConfig getSearchSyncConfig() {
        return DefaultSearchSync.getDefaultSearchSyncConfig();
    }

    public static enum FaildReason {

    }
}

