/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.search.sync.impl;

import com.valor.common.search.sync.SearchSyncConfig;
import com.valor.common.search.sync.utils.CollectionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;

public class DefaultSearchSyncConfig {
    public static final SearchSyncConfig initFromConfig(String configResource) throws IOException {
        try (InputStream stream = DefaultSearchSyncConfig.getConfigStream(configResource);){
            SearchSyncConfig searchSyncConfig = DefaultSearchSyncConfig.initFromConfig(stream);
            return searchSyncConfig;
        }
    }

    public static final SearchSyncConfig initFromConfig(InputStream stream) throws IOException {
        Properties props = new Properties();
        props.load(stream);
        return DefaultSearchSyncConfig.initFromConfig(props);
    }

    private static InputStream getConfigStream(String resource) throws IOException {
        InputStream configStream = DefaultSearchSyncConfig.class.getResourceAsStream(resource);
        if (configStream == null) {
            configStream = DefaultSearchSyncConfig.class.getClassLoader().getParent().getResourceAsStream(resource);
        }
        if (configStream == null) {
            throw new IOException("Cannot find " + resource + " !!!");
        }
        return configStream;
    }

    private static SearchSyncConfig initFromConfig(Properties props) {
        SearchSyncConfig settings = new SearchSyncConfig();
        settings.setHost(props.getProperty("search.engine.host", "localhost"));
        settings.setPort(Integer.parseInt(props.getProperty("search.engine.port", "9200")));
        settings.setUsername(props.getProperty("search.engine.username", ""));
        settings.setPassword(props.getProperty("search.engine.password", ""));
        settings.setIndexName(props.getProperty("search.engine.index.name", "search_engine_index"));
        settings.setIndexType(props.getProperty("search.engine.index.type", "search_engine_index"));
        settings.setMatchMainIndicFieldName(props.getProperty("search.engine.index.main-indic-field-name", "mainTitle"));
        settings.setDocumentIdentifyFieldName(props.getProperty("search.engine.index.document-identify-field-name", "docId"));
        String strIndicSourceFiledName = props.getProperty("search.engine.index.main-indic-source-field-name", "title,keywords");
        settings.setMainIndicSourceFieldsName(CollectionUtils.arrayToList(strIndicSourceFiledName.split(",")));
        String strExtFieldToIndexMap = props.getProperty("search.engine.index.ext-field-to-index-map", "");
        Properties extFieldToIndexMapProps = new Properties();
        Arrays.stream(strExtFieldToIndexMap.split("\\|")).forEachOrdered(item -> {
            String[] p = item.split(":");
            if (p.length == 2) {
                extFieldToIndexMapProps.setProperty(p[0], p[1]);
            }
        });
        settings.setExtFieldToIndexProps(extFieldToIndexMapProps);
        return settings;
    }
}

