package com.valor.web.springboot.starter.valorweb.autoconfiguation;

import com.valor.web.springboot.starter.valorweb.filter.crypt.RequestCryptFilter;
import com.valor.web.springboot.starter.valorweb.filter.crypt.ResponseCryptFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;

@Service
public class ValorWebAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ValorWebAutoConfiguration.class);

    @Bean
    @ConditionalOnWebApplication
    public FilterRegistrationBean<RequestCryptFilter> requestCryptFilter() {
        FilterRegistrationBean<RequestCryptFilter> filterRegistrationBean = new FilterRegistrationBean<>();
        filterRegistrationBean.setFilter(new RequestCryptFilter());
        filterRegistrationBean.setUrlPatterns(new ArrayList<>(Arrays.asList("/api/*")));
        filterRegistrationBean.setOrder(1_000);
        filterRegistrationBean.setName(RequestCryptFilter.class.getSimpleName());

        logger.info("Add Filter name:[{}] order[{}]","RequestCryptFilter",filterRegistrationBean.getOrder());

        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnWebApplication
    public FilterRegistrationBean<ResponseCryptFilter> responseCryptFilter() {
        FilterRegistrationBean<ResponseCryptFilter> filterRegistrationBean = new FilterRegistrationBean<>();
        filterRegistrationBean.setFilter(new ResponseCryptFilter());
        filterRegistrationBean.setUrlPatterns(new ArrayList<>(Arrays.asList("/api/*")));
        filterRegistrationBean.setOrder(2_000);

        logger.info("Add Filter name:[{}] order[{}]","ResponseCryptFilter",filterRegistrationBean.getOrder());
        return filterRegistrationBean;
    }
}
