package com.valor.web.springboot.starter.valorweb.filter.crypt;


import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Strings;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl.CryptProtocolProcessor;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl.CryptProtocolProcessorFactory;

import com.valor.web.utils.wrapper.WebRequestWrapper;
import common.base.tools.JSON.JSONTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

public class RequestCryptFilter extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequestCryptFilter.class);

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
            throws ServletException, IOException {

        WebRequestWrapper wrapper = new WebRequestWrapper(request);
        String v = wrapper.getParameter("v");
        if (Strings.isNullOrEmpty(v)) {
            v = wrapper.getParameter("prot");
        }

        String m = wrapper.getParameter("m");
        if (Strings.isNullOrEmpty(m)) {
            m = wrapper.getParameter("payload");
        }

        String s = wrapper.getParameter("s");
        if (Strings.isNullOrEmpty(s)) {
            s = wrapper.getParameter("signature");
        }

        if (!Strings.isNullOrEmpty(v) && !Strings.isNullOrEmpty(m) && isSupport(request)) {
            try {
                CryptProtocolProcessor processor = CryptProtocolProcessorFactory.getProcessor(v);
                String dm = processor.decrypt(v, m, s);
                Map<String, Object> decryptMap = JSONTools.fromJson2(dm, new TypeReference<Map<String, Object>>() {
                });

                if (decryptMap != null && !decryptMap.isEmpty()) {
                    wrapper.addAllParameters(decryptMap);
                    //Set request body
                    wrapper.setOriginalBodyStr(dm);
                }
            } catch (Exception e) {
                logger.error(String.format("Bad request: Invalid request parameter. m=[%s], v=[%s]", m, v), e);
                throw new IllegalArgumentException("Bad request: Invalid request parameter");
            }
        }

        filterChain.doFilter(wrapper, response);
    }

    @Override
    public void destroy() {
        // empty interface implementation
    }

    public boolean isSupport(HttpServletRequest request) {
        String url = request.getRequestURI();
        return !url.startsWith("/api/ping/");
    }
}
