package com.valor.web.springboot.starter.valorweb.filter.crypt;


import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.EProtocol;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl.CryptProtocolProcessor;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl.CryptProtocolProcessorFactory;
import com.valor.web.springboot.starter.valorweb.utils.crypt.CryptACL;
import com.valor.web.springboot.starter.valorweb.utils.crypt.model.ApiCryptMsg;
import com.valor.web.springboot.starter.valorweb.utils.crypt.model.ApiCryptMsg4Live;
import com.valor.web.utils.wrapper.WebResponseWrapper;
import common.base.tools.sys.SystemTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;


public class ResponseCryptFilter extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(ResponseCryptFilter.class);
    private Gson gson = new Gson();

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        WebResponseWrapper wrapper = new WebResponseWrapper(response);
        try {
            filterChain.doFilter(request, wrapper);
            doCryptMsg(request, wrapper);
        } finally {
            wrapper.copyBodyToResponse();
        }
    }

    private boolean doCryptMsg(HttpServletRequest request, WebResponseWrapper wrapper) throws IOException {

        String v = request.getParameter("v");
        if (Strings.isNullOrEmpty(v)) {
            v = request.getParameter("prot");
        }

        if (!EProtocol.isSupportProtocol(v)) {
            return true;
        }

        String url = request.getRequestURI();
        if (url.startsWith("/api/ping/")) {
            return true;
        }

        //非支持的ContentType直接返回
        if (CryptACL.isDisableContentType(wrapper.getContentType())) {
            return true;
        }

        byte[] contentByte = wrapper.getContentAsByteArray();
        if (contentByte.length > 0) {
            String content = encryptMsg(url, v, contentByte);
            if (!wrapper.isCommitted()) {
                wrapper.resetBuffer();
            }
            wrapper.getOutputStream().write(content.getBytes(StandardCharsets.UTF_8));
        }
        return false;
    }

    @Override
    public void destroy() {
        // empty interface implementation
    }


    /**
     * encode http content
     *
     * @param url
     * @param v
     * @param data
     * @return
     * @throws IOException
     */
    private String encryptMsg(String url, String v, byte[] data) throws IOException {

        String content = new String(data, StandardCharsets.UTF_8);
        if (!EProtocol.isSupportProtocol(v)) {
            return content;
        }

        String signature = "";
        CryptProtocolProcessor processor = CryptProtocolProcessorFactory.getProcessor(v);
        if (processor != null) {
            content = processor.encrypt(v, content);
            signature = processor.sign(v, content);
        }

        Object retObj = null;
        String h = SystemTools.getHostnameMD5();
        long t = System.currentTimeMillis();

        if (EProtocol.isVod(v)) {
            retObj = new ApiCryptMsg(h, t, v, content, signature);
        } else {
            retObj = new ApiCryptMsg4Live(v, "rsp", "*", content, signature);
        }

        return gson.toJson(retObj);
    }

}
