package com.valor.web.springboot.starter.valorweb.filter.crypt.processor;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.valor.web.springboot.starter.valorweb.filter.crypt.CryptConstants;
import common.config.tools.config.ConfigTools3;

import java.util.Optional;

/**
 * Interface from crypt2
 *
 * @Author: Frank.Huang
 * @Date: 2019-06-05
 * @Version: 1.0.0
 */
public interface ICryptProcessor extends IRequestCryptProcessor, IResponseCryptProcessor {
    /**
     * Get protocol
     *
     * @return
     */
    String getProtocol();

    /**
     * Get crypt type
     *
     * @return
     */
    ECryptType getCryptType();

    /**
     * @return
     */
    default String getCryptTypeName() {
        Optional<ECryptType> cryptTypeOptional = Optional.of(getCryptType());
        if (cryptTypeOptional.isPresent()) {
            return cryptTypeOptional.get().name().toLowerCase();
        } else {
            return null;
        }
    }

    /**
     * Get property
     *
     * @param key
     * @return
     */
    default String getProperty(String key) {
        /**
         * Search order:
         *   key.{protocol}.{CryptType}
         *   key.{protocol}.{CryptType}
         *   key
         */

        String k = "";
        String v = "";

        //[key].[crypt-type].[protocol]
        k = buildCfgKey(key, getProtocol(), getCryptTypeName());
        v = ConfigTools3.getString(k);
        if (!Strings.isNullOrEmpty(v)) {
            return v;
        }


        // [key].[crypt-type]
        k = buildCfgKey(key, getProtocol());
        v = ConfigTools3.getString(k);
        if (!Strings.isNullOrEmpty(v)) {
            return v;
        }

        //[key]
        return ConfigTools3.getString(key);
    }

    default boolean getBoolProperty(String key, boolean defVal) {
        String v = getProperty(key);
        if (Strings.isNullOrEmpty(v)) {
            return defVal;
        }

        if (v.contentEquals("true") || v.contentEquals("1")) {
            return true;
        }
        if (v.contentEquals("false") || v.contentEquals("0")) {
            return false;
        }

        return defVal;
    }

    default boolean getBoolProperty(String key) {
        return getBoolProperty(key, false);
    }

    default int getIntProperty(String key, int defaultValue) {
        String v = getProperty(key);
        if (Strings.isNullOrEmpty(v)) {
            return 0;
        }

        try {
            return Integer.parseInt(key);
        } catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default String buildCfgKey(String... keys) {
        return Joiner.on(".").skipNulls().join(keys);
    }


    @Override
    default boolean isRequestCrypt() {
        return getBoolProperty(CryptConstants.CRYPT_CFG_CRYPT_REQUEST, true);
    }

    @Override
    default boolean isRequestSign() {
        return getBoolProperty(CryptConstants.CRYPT_CFG_SIGN_REQUEST, false);
    }

    @Override
    default boolean isResponseCrypt() {
        return getBoolProperty(CryptConstants.CRYPT_CFG_CRYPT_RESPONSE, true);
    }

    @Override
    default boolean isResponseSign() {
        return getBoolProperty(CryptConstants.CRYPT_CFG_SIGN_RESPONSE, false);
    }
}
