package com.valor.web.springboot.starter.valorweb.filter.crypt.processor;

public interface IRequestCryptProcessor {
    /**
     * Decrypt message
     *
     * @param message
     * @return
     */
    String decrypt(String message);

    /**
     * Check signature
     *
     * @param msg
     * @param signature
     * @return
     */
    default boolean checkSignature(String msg, String signature) {
        return true;
    }

    /**
     * Request support crypt or not
     */
    default boolean isRequestCrypt() {
        return true;
    }

    /**
     * Request sign or not
     */
    default boolean isRequestSign() {
        return false;
    }
}
