package com.valor.web.springboot.starter.valorweb.filter.crypt.processor;

public interface IResponseCryptProcessor {
    /**
     * Encrypt message
     *
     * @param message
     * @return
     */
    String encrypt(String message);


    /**
     * Signature message
     *
     * @param message
     * @return
     */
    default String signature(String message) {
        return "";
    }

    /**
     * Response support crypt or not
     */
    default boolean isResponseCrypt() {
        return true;
    }

    /**
     * Response sign or not
     */
    default boolean isResponseSign() {
        return false;
    }
}
