package com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl;

import com.google.common.base.Strings;
import com.valor.web.springboot.starter.valorweb.filter.crypt.CryptConstants;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.ECryptType;
import common.base.tools.encrypt.AESIVTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESCryptProcessor extends AbstractCryptProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AESCryptProcessor.class);

    public AESCryptProcessor(String protocol, ECryptType ECryptType) {
        super(protocol, ECryptType, true, false, true, false);
    }

    public AESCryptProcessor(String protocol, ECryptType cryptType, boolean enableReqCrypt, boolean enableReqSign, boolean enableRespCrypt, boolean enableRespSign) {
        super(protocol, cryptType, enableReqCrypt, enableReqSign, enableRespCrypt, enableRespSign);
    }

    @Override
    public String decrypt(String content) {
        if (!isRequestCrypt()) {
            return content;
        }

        return AESIVTools.decrypt(content, getAesKey(), getAesIV());
    }


    @Override
    public String encrypt(String content) {
        if (!isResponseCrypt()) {
            return content;
        }
        return AESIVTools.encrypt(content, getAesKey(), getAesIV());
    }

    public String getAesKey() {
        String aesKey = getProperty(CryptConstants.CRYPT_CFG_AES_KEY);
        if (Strings.isNullOrEmpty(aesKey)) {
            return CryptConstants.CRYPT_CFG_AES_KEY_DEFAULT;
        } else {
            return aesKey;
        }
    }

    public String getAesIV() {
        String aesIv = getProperty(CryptConstants.CRYPT_CFG_AES_IV);
        if (Strings.isNullOrEmpty(aesIv)) {
            return CryptConstants.CRYPT_CFG_AES_IV_DEFAULT;
        } else {
            return aesIv;
        }
    }
}
