package com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl;

import com.valor.web.springboot.starter.valorweb.filter.crypt.CryptConstants;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.ECryptType;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.ICryptProcessor;

public abstract class AbstractCryptProcessor implements ICryptProcessor {
    private String protocol;
    private ECryptType cryptType;

    private boolean enableReqCrypt;
    private boolean enableReqSign;
    private boolean enableRespCrypt;
    private boolean enableRespSign;

    public AbstractCryptProcessor(String protocol, ECryptType cryptType, boolean enableReqCrypt, boolean enableReqSign, boolean enableRespCrypt, boolean enableRespSign) {
        this.protocol = protocol;
        this.cryptType = cryptType;
        this.enableReqCrypt = enableReqCrypt;
        this.enableReqSign = enableReqSign;
        this.enableRespCrypt = enableRespCrypt;
        this.enableRespSign = enableRespSign;
    }

    @Override
    public String getProtocol() {
        return protocol;
    }

    @Override
    public ECryptType getCryptType() {
        return cryptType;
    }

    @Override
    public boolean isRequestCrypt() {
        return getBoolProperty(CryptConstants.CRYPT_CFG_CRYPT_REQUEST, enableReqCrypt);
    }

    @Override
    public boolean isRequestSign() {
        return getBoolProperty(CryptConstants.CRYPT_CFG_SIGN_REQUEST, enableReqSign);
    }

    @Override
    public boolean isResponseCrypt() {
        return getBoolProperty(CryptConstants.CRYPT_CFG_CRYPT_RESPONSE, enableRespCrypt);
    }

    @Override
    public boolean isResponseSign() {
        return getBoolProperty(CryptConstants.CRYPT_CFG_SIGN_RESPONSE, enableRespSign);
    }
}
