package com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.ICryptProcessor;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.IRequestCryptProcessor;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.IResponseCryptProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.TreeMap;

public class CryptProtocolProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CryptProtocolProcessor.class);

    private String protocol;
    private TreeMap<Integer, ICryptProcessor> processorChain = Maps.newTreeMap();

    public CryptProtocolProcessor(String protocol) {
        this.protocol = protocol;
    }

    public CryptProtocolProcessor addProcessor(int order, ICryptProcessor processor) {
        processorChain.put(order, processor);
        return this;
    }

    public String decrypt(String protocol, String content, String signature) {
        List<ICryptProcessor> processors = Lists.newLinkedList(processorChain.values());

        String decryptContent = content;
        for (IRequestCryptProcessor p : Lists.reverse(processors)) {
            boolean isSign = p.checkSignature(decryptContent, signature);
            if (!isSign) {
                return "";
            }

            decryptContent = p.decrypt(decryptContent);
            if (Strings.isNullOrEmpty(decryptContent)) {
                return "";
            }
        }

        return decryptContent;
    }

    public String encrypt(String protocol, String content) {
        List<ICryptProcessor> processors = Lists.newLinkedList(processorChain.values());
        String cryptContent = content;
        for (IResponseCryptProcessor p : processors) {
            cryptContent = p.encrypt(cryptContent);
            if (Strings.isNullOrEmpty(cryptContent)) {
                return "";
            }
        }

        return cryptContent;
    }

    public String sign(String protocol, String content) {
        List<ICryptProcessor> processors = Lists.newLinkedList(processorChain.values());
        String cryptContent = content;
        for (IResponseCryptProcessor p : processors) {
            cryptContent = p.signature(cryptContent);
            if (Strings.isNullOrEmpty(cryptContent)) {
                return "";
            }
        }

        return cryptContent;
    }

    public String getProtocol() {
        return protocol;
    }
}
