package com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl;

import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.ECryptType;
import common.base.tools.compress.GZipTools;

public class GzipCryptProcessor extends AbstractCryptProcessor {

    public GzipCryptProcessor(String protocol, ECryptType ECryptType) {
        super(protocol, ECryptType, false, false, true, false);
    }

    public GzipCryptProcessor(String protocol, ECryptType cryptType, boolean enableReqCrypt, boolean enableReqSign, boolean enableRespCrypt, boolean enableRespSign) {
        super(protocol, cryptType, enableReqCrypt, enableReqSign, enableRespCrypt, enableRespSign);
    }

    @Override
    public String decrypt(String content) {
        if (!isRequestCrypt()) {
            return content;
        }

        return GZipTools.decompress(content);
    }

    @Override
    public String encrypt(String content) {
        if (!isResponseCrypt()) {
            return content;
        }

        return GZipTools.compress(content);
    }
}
