package com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl;

import com.google.common.base.Strings;
import com.ijiami.JMEncryptBox;
import com.ijiami.JMEncryptBoxByRandom;
import com.ijiami.ResultData;
import com.valor.web.springboot.starter.valorweb.filter.crypt.CryptConstants;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.ECryptType;
import common.config.tools.config.ConfigTools3;
import com.valor.web.springboot.starter.valorweb.utils.crypt.ijiami.IJMConstants;
import com.valor.web.springboot.starter.valorweb.utils.crypt.ijiami.IJMLogImpl;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IJMCryptProcessor extends AbstractCryptProcessor {
    private static final Logger logger = LoggerFactory.getLogger(IJMCryptProcessor.class);

    public IJMCryptProcessor(String protocol, ECryptType ECryptType) {
        this(protocol, ECryptType, true, false, true, false);
        init();
    }

    public IJMCryptProcessor(String protocol, ECryptType cryptType, boolean enableReqCrypt, boolean enableReqSign, boolean enableRespCrypt, boolean enableRespSign) {
        super(protocol, cryptType, enableReqCrypt, enableReqSign, enableRespCrypt, enableRespSign);
    }

    public static void init() {
        String defaultPath = FileUtils.getUserDirectoryPath().toLowerCase() + "/.valor/crypt/dll";
        String dllPath = ConfigTools3.getString("crypt.dll.path", defaultPath);

        logger.info("IJM load Dll form [{}]", dllPath);
        boolean ret = JMEncryptBox.initLoadDllPath(dllPath, new IJMLogImpl());
        logger.info("IJM Init ret:[{}],path[{}]", ret, dllPath);
        if (!ret) {
            throw new IllegalArgumentException(String.format("IJM DLL Load failed!path:%s", dllPath));
        }
    }

    @Override
    public String decrypt(String content) {
        int algorithmType = getIJMAlgorithm();
        try {
            ResultData resultData = JMEncryptBoxByRandom.decryptFromBase64(content, algorithmType);
            if (resultData.getStatus() == IJMConstants.DECRYPT_STATUS_SUCCESS) {
                return resultData.getText();
            } else {
                logger.error("IJM Decrypt failed:{}{}", resultData.getStatus(), content);
                return "";
            }

        } catch (Exception e) {
            logger.error("IJM Decrypt field Type:[{}] Content:[{}]", algorithmType, content, e);
            return "";
        }
    }

    @Override
    public String encrypt(String content) {
        if (Strings.isNullOrEmpty(content)) {
            return "";
        }
        int algorithmType = getIJMAlgorithm();
        try {
            String encryptMsg = JMEncryptBoxByRandom.encryptToBase64(content, algorithmType);
            if (Strings.isNullOrEmpty(encryptMsg)) {
                logger.error("IJM Encrypt failed:[{}] [{}]", algorithmType, content);
            }
            return encryptMsg;
        } catch (Exception e) {
            logger.error("IJM Encrypt failed! content:[{}]", algorithmType, e);
        }
        return "";
    }

    private int getIJMAlgorithm() {
        return getIntProperty(CryptConstants.CRYPT_CFG_ALGORITHM_TYPE, IJMConstants.ALGORITHM_AES);
    }

}
