/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.valorweb.autoconfiguation;

import com.valor.web.springboot.starter.valorweb.filter.crypt.RequestCryptFilter;
import com.valor.web.springboot.starter.valorweb.filter.crypt.ResponseCryptFilter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;

@Service
public class ValorWebAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ValorWebAutoConfiguration.class);

    @Bean
    @ConditionalOnWebApplication
    public FilterRegistrationBean<RequestCryptFilter> requestCryptFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new RequestCryptFilter());
        filterRegistrationBean.setUrlPatterns(new ArrayList<String>(Arrays.asList("/api/*")));
        filterRegistrationBean.setOrder(1000);
        filterRegistrationBean.setName(RequestCryptFilter.class.getSimpleName());
        logger.info("Add Filter name:[{}] order[{}]", (Object)"RequestCryptFilter", (Object)filterRegistrationBean.getOrder());
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnWebApplication
    public FilterRegistrationBean<ResponseCryptFilter> responseCryptFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new ResponseCryptFilter());
        filterRegistrationBean.setUrlPatterns(new ArrayList<String>(Arrays.asList("/api/*")));
        filterRegistrationBean.setOrder(2000);
        logger.info("Add Filter name:[{}] order[{}]", (Object)"ResponseCryptFilter", (Object)filterRegistrationBean.getOrder());
        return filterRegistrationBean;
    }
}

