/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.valorweb.filter.crypt;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Strings;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl.CryptProtocolProcessor;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl.CryptProtocolProcessorFactory;
import com.valor.web.utils.wrapper.WebRequestWrapper;
import common.base.tools.JSON.JSONTools;
import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequestCryptFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequestCryptFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String s;
        String m;
        WebRequestWrapper wrapper = new WebRequestWrapper(request);
        String v = wrapper.getParameter("v");
        if (Strings.isNullOrEmpty((String)v)) {
            v = wrapper.getParameter("prot");
        }
        if (Strings.isNullOrEmpty((String)(m = wrapper.getParameter("m")))) {
            m = wrapper.getParameter("payload");
        }
        if (Strings.isNullOrEmpty((String)(s = wrapper.getParameter("s")))) {
            s = wrapper.getParameter("signature");
        }
        if (!Strings.isNullOrEmpty((String)v) && !Strings.isNullOrEmpty((String)m) && this.isSupport(request)) {
            try {
                CryptProtocolProcessor processor = CryptProtocolProcessorFactory.getProcessor(v);
                String dm = processor.decrypt(v, m, s);
                Map decryptMap = (Map)JSONTools.fromJson2((String)dm, (TypeReference)new TypeReference<Map<String, Object>>(){});
                if (decryptMap != null && !decryptMap.isEmpty()) {
                    wrapper.addAllParameters(decryptMap);
                    wrapper.setOriginalBodyStr(dm);
                }
            }
            catch (Exception e) {
                logger.error(String.format("Bad request: Invalid request parameter. m=[%s], v=[%s]", m, v), (Throwable)e);
                throw new IllegalArgumentException("Bad request: Invalid request parameter");
            }
        }
        filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)response);
    }

    public void destroy() {
    }

    public boolean isSupport(HttpServletRequest request) {
        String url = request.getRequestURI();
        return !url.startsWith("/api/ping/");
    }
}

