/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.valorweb.filter.crypt;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.EProtocol;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl.CryptProtocolProcessor;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl.CryptProtocolProcessorFactory;
import com.valor.web.springboot.starter.valorweb.utils.crypt.CryptACL;
import com.valor.web.springboot.starter.valorweb.utils.crypt.model.ApiCryptMsg;
import com.valor.web.springboot.starter.valorweb.utils.crypt.model.ApiCryptMsg4Live;
import com.valor.web.utils.wrapper.WebResponseWrapper;
import common.base.tools.AbstractPrintable;
import common.base.tools.sys.SystemTools;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class ResponseCryptFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(ResponseCryptFilter.class);
    private Gson gson = new Gson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        WebResponseWrapper wrapper = new WebResponseWrapper(response);
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
            this.doCryptMsg(request, wrapper);
        }
        finally {
            wrapper.copyBodyToResponse();
        }
    }

    private boolean doCryptMsg(HttpServletRequest request, WebResponseWrapper wrapper) throws IOException {
        String v = request.getParameter("v");
        if (Strings.isNullOrEmpty((String)v)) {
            v = request.getParameter("prot");
        }
        if (!EProtocol.isSupportProtocol(v)) {
            return true;
        }
        String url = request.getRequestURI();
        if (url.startsWith("/api/ping/")) {
            return true;
        }
        if (CryptACL.isDisableContentType(wrapper.getContentType())) {
            return true;
        }
        byte[] contentByte = wrapper.getContentAsByteArray();
        if (contentByte.length > 0) {
            String content = this.encryptMsg(url, v, contentByte);
            if (!wrapper.isCommitted()) {
                wrapper.resetBuffer();
            }
            wrapper.getOutputStream().write(content.getBytes(StandardCharsets.UTF_8));
        }
        return false;
    }

    public void destroy() {
    }

    private String encryptMsg(String url, String v, byte[] data) throws IOException {
        String content = new String(data, StandardCharsets.UTF_8);
        if (!EProtocol.isSupportProtocol(v)) {
            return content;
        }
        String signature = "";
        CryptProtocolProcessor processor = CryptProtocolProcessorFactory.getProcessor(v);
        if (processor != null) {
            content = processor.encrypt(v, content);
            signature = processor.sign(v, content);
        }
        AbstractPrintable retObj = null;
        String h = SystemTools.getHostnameMD5();
        long t = System.currentTimeMillis();
        retObj = EProtocol.isVod(v) ? new ApiCryptMsg(h, t, v, content, signature) : new ApiCryptMsg4Live(v, "rsp", "*", content, signature);
        return this.gson.toJson((Object)retObj);
    }
}

