/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.valorweb.filter.crypt.processor;

import com.google.common.base.Strings;

public enum EProtocol {
    PROTOCOL_3("3"),
    PROTOCOL_4("4"),
    PROTOCOL_ACM1("ACM1"),
    PROTOCOL_ACM11("ACM11"),
    PROTOCOL_ACM20("ACM20"),
    PROTOCOL_ACM21("ACM21"),
    PROTOCOL_ACM30("ACM30"),
    PROTOCOL_UNKOWN("UNKOWN");

    private String protocol = "UNKOWN";

    private EProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean equal(String protocol) {
        return this.protocol.contentEquals(protocol);
    }

    public static boolean isSupportProtocol(String protocol) {
        if (Strings.isNullOrEmpty((String)protocol)) {
            return false;
        }
        for (EProtocol p : EProtocol.values()) {
            if (p == PROTOCOL_UNKOWN || !p.equal(protocol)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVod(String protocol) {
        return PROTOCOL_3.equal(protocol) || PROTOCOL_4.equal(protocol);
    }
}

