/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.valorweb.filter.crypt.processor;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.ECryptType;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.IRequestCryptProcessor;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.IResponseCryptProcessor;
import common.config.tools.config.ConfigTools3;
import java.util.Optional;

public interface ICryptProcessor
extends IRequestCryptProcessor,
IResponseCryptProcessor {
    public String getProtocol();

    public ECryptType getCryptType();

    default public String getCryptTypeName() {
        Optional<ECryptType> cryptTypeOptional = Optional.of(this.getCryptType());
        if (cryptTypeOptional.isPresent()) {
            return cryptTypeOptional.get().name().toLowerCase();
        }
        return null;
    }

    default public String getProperty(String key) {
        String k = "";
        String v = "";
        k = this.buildCfgKey(key, this.getProtocol(), this.getCryptTypeName());
        v = ConfigTools3.getString((String)k);
        if (!Strings.isNullOrEmpty((String)v)) {
            return v;
        }
        k = this.buildCfgKey(key, this.getProtocol());
        v = ConfigTools3.getString((String)k);
        if (!Strings.isNullOrEmpty((String)v)) {
            return v;
        }
        return ConfigTools3.getString((String)key);
    }

    default public boolean getBoolProperty(String key, boolean defVal) {
        String v = this.getProperty(key);
        if (Strings.isNullOrEmpty((String)v)) {
            return defVal;
        }
        if (v.contentEquals("true") || v.contentEquals("1")) {
            return true;
        }
        if (v.contentEquals("false") || v.contentEquals("0")) {
            return false;
        }
        return defVal;
    }

    default public boolean getBoolProperty(String key) {
        return this.getBoolProperty(key, false);
    }

    default public int getIntProperty(String key, int defaultValue) {
        String v = this.getProperty(key);
        if (Strings.isNullOrEmpty((String)v)) {
            return 0;
        }
        try {
            return Integer.parseInt(key);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public String buildCfgKey(String ... keys) {
        return Joiner.on((String)".").skipNulls().join((Object[])keys);
    }

    @Override
    default public boolean isRequestCrypt() {
        return this.getBoolProperty("crypt.crypt.request", true);
    }

    @Override
    default public boolean isRequestSign() {
        return this.getBoolProperty("crypt.sign.request", false);
    }

    @Override
    default public boolean isResponseCrypt() {
        return this.getBoolProperty("crypt.crypt.response", true);
    }

    @Override
    default public boolean isResponseSign() {
        return this.getBoolProperty("crypt.sign.response", false);
    }
}

