/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl;

import com.google.common.base.Strings;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.ECryptType;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl.AbstractCryptProcessor;
import common.base.tools.encrypt.AESIVTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESCryptProcessor
extends AbstractCryptProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AESCryptProcessor.class);

    public AESCryptProcessor(String protocol, ECryptType ECryptType2) {
        super(protocol, ECryptType2, true, false, true, false);
    }

    public AESCryptProcessor(String protocol, ECryptType cryptType, boolean enableReqCrypt, boolean enableReqSign, boolean enableRespCrypt, boolean enableRespSign) {
        super(protocol, cryptType, enableReqCrypt, enableReqSign, enableRespCrypt, enableRespSign);
    }

    @Override
    public String decrypt(String content) {
        if (!this.isRequestCrypt()) {
            return content;
        }
        return AESIVTools.decrypt((String)content, (String)this.getAesKey(), (String)this.getAesIV());
    }

    @Override
    public String encrypt(String content) {
        if (!this.isResponseCrypt()) {
            return content;
        }
        return AESIVTools.encrypt((String)content, (String)this.getAesKey(), (String)this.getAesIV());
    }

    public String getAesKey() {
        String aesKey = this.getProperty("crypt.aes.key");
        if (Strings.isNullOrEmpty((String)aesKey)) {
            return "ZCZtaGFrY2tlOXZjMmpaQw==";
        }
        return aesKey;
    }

    public String getAesIV() {
        String aesIv = this.getProperty("crypt.aes.iv");
        if (Strings.isNullOrEmpty((String)aesIv)) {
            return "oDG&6zcgcpvqkgv6";
        }
        return aesIv;
    }
}

