/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.ICryptProcessor;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.IRequestCryptProcessor;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.IResponseCryptProcessor;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptProtocolProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CryptProtocolProcessor.class);
    private String protocol;
    private TreeMap<Integer, ICryptProcessor> processorChain = Maps.newTreeMap();

    public CryptProtocolProcessor(String protocol) {
        this.protocol = protocol;
    }

    public CryptProtocolProcessor addProcessor(int order, ICryptProcessor processor) {
        this.processorChain.put(order, processor);
        return this;
    }

    public String decrypt(String protocol, String content, String signature) {
        LinkedList processors = Lists.newLinkedList(this.processorChain.values());
        String decryptContent = content;
        for (IRequestCryptProcessor p : Lists.reverse((List)processors)) {
            boolean isSign = p.checkSignature(decryptContent, signature);
            if (!isSign) {
                return "";
            }
            if (!Strings.isNullOrEmpty((String)(decryptContent = p.decrypt(decryptContent)))) continue;
            return "";
        }
        return decryptContent;
    }

    public String encrypt(String protocol, String content) {
        LinkedList processors = Lists.newLinkedList(this.processorChain.values());
        String cryptContent = content;
        for (IResponseCryptProcessor p : processors) {
            cryptContent = p.encrypt(cryptContent);
            if (!Strings.isNullOrEmpty((String)cryptContent)) continue;
            return "";
        }
        return cryptContent;
    }

    public String sign(String protocol, String content) {
        LinkedList processors = Lists.newLinkedList(this.processorChain.values());
        String cryptContent = content;
        for (IResponseCryptProcessor p : processors) {
            cryptContent = p.signature(cryptContent);
            if (!Strings.isNullOrEmpty((String)cryptContent)) continue;
            return "";
        }
        return cryptContent;
    }

    public String getProtocol() {
        return this.protocol;
    }
}

