/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl;

import com.google.common.collect.Maps;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.ECryptType;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.EProtocol;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl.AESCryptProcessor;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl.CryptProtocolProcessor;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl.IJMCryptProcessor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptProtocolProcessorFactory {
    private static final Logger logger = LoggerFactory.getLogger(CryptProtocolProcessorFactory.class);
    private static Map<String, CryptProtocolProcessor> processorMap = Maps.newLinkedHashMap();

    public static CryptProtocolProcessor getProcessor(String protocol) {
        if (processorMap.containsKey(protocol)) {
            return processorMap.get(protocol);
        }
        return null;
    }

    public static void addProcessor(CryptProtocolProcessor processor) {
        processorMap.put(processor.getProtocol(), processor);
    }

    public static void initProcessor() {
        CryptProtocolProcessorFactory.addProcessor(CryptProtocolProcessorFactory.getACM30Processor());
    }

    private static CryptProtocolProcessor getACM30Processor() {
        String protocol = EProtocol.PROTOCOL_ACM30.getProtocol();
        CryptProtocolProcessor acm30Processor = new CryptProtocolProcessor(protocol);
        acm30Processor.addProcessor(1, new IJMCryptProcessor(protocol, ECryptType.IJM));
        acm30Processor.addProcessor(2, new AESCryptProcessor(protocol, ECryptType.AES));
        return acm30Processor;
    }

    static {
        CryptProtocolProcessorFactory.initProcessor();
    }
}

