/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl;

import com.google.common.base.Strings;
import com.ijiami.JMEncryptBox;
import com.ijiami.JMEncryptBoxByRandom;
import com.ijiami.LoadMessage;
import com.ijiami.ResultData;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.ECryptType;
import com.valor.web.springboot.starter.valorweb.filter.crypt.processor.impl.AbstractCryptProcessor;
import com.valor.web.springboot.starter.valorweb.utils.crypt.ijiami.IJMConstants;
import com.valor.web.springboot.starter.valorweb.utils.crypt.ijiami.IJMLogImpl;
import common.config.tools.config.ConfigTools3;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IJMCryptProcessor
extends AbstractCryptProcessor {
    private static final Logger logger = LoggerFactory.getLogger(IJMCryptProcessor.class);

    public IJMCryptProcessor(String protocol, ECryptType ECryptType2) {
        this(protocol, ECryptType2, true, false, true, false);
        IJMCryptProcessor.init();
    }

    public IJMCryptProcessor(String protocol, ECryptType cryptType, boolean enableReqCrypt, boolean enableReqSign, boolean enableRespCrypt, boolean enableRespSign) {
        super(protocol, cryptType, enableReqCrypt, enableReqSign, enableRespCrypt, enableRespSign);
    }

    public static void init() {
        String defaultPath = FileUtils.getUserDirectoryPath().toLowerCase() + "/.valor/crypt/dll";
        String dllPath = ConfigTools3.getString((String)"crypt.dll.path", (String)defaultPath);
        logger.info("IJM load Dll form [{}]", (Object)dllPath);
        boolean ret = JMEncryptBox.initLoadDllPath((String)dllPath, (LoadMessage)new IJMLogImpl());
        logger.info("IJM Init ret:[{}],path[{}]", (Object)ret, (Object)dllPath);
        if (!ret) {
            throw new IllegalArgumentException(String.format("IJM DLL Load failed!path:%s", dllPath));
        }
    }

    @Override
    public String decrypt(String content) {
        int algorithmType = this.getIJMAlgorithm();
        try {
            ResultData resultData = JMEncryptBoxByRandom.decryptFromBase64((String)content, (int)algorithmType);
            if (resultData.getStatus() == IJMConstants.DECRYPT_STATUS_SUCCESS) {
                return resultData.getText();
            }
            logger.error("IJM Decrypt failed:{}{}", (Object)resultData.getStatus(), (Object)content);
            return "";
        }
        catch (Exception e) {
            logger.error("IJM Decrypt field Type:[{}] Content:[{}]", new Object[]{algorithmType, content, e});
            return "";
        }
    }

    @Override
    public String encrypt(String content) {
        if (Strings.isNullOrEmpty((String)content)) {
            return "";
        }
        int algorithmType = this.getIJMAlgorithm();
        try {
            String encryptMsg = JMEncryptBoxByRandom.encryptToBase64((String)content, (int)algorithmType);
            if (Strings.isNullOrEmpty((String)encryptMsg)) {
                logger.error("IJM Encrypt failed:[{}] [{}]", (Object)algorithmType, (Object)content);
            }
            return encryptMsg;
        }
        catch (Exception e) {
            logger.error("IJM Encrypt failed! content:[{}]", (Object)algorithmType, (Object)e);
            return "";
        }
    }

    private int getIJMAlgorithm() {
        return this.getIntProperty("crypt.algorithm.type", IJMConstants.ALGORITHM_AES);
    }
}

