/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.valorweb.utils.crypt;

import com.google.common.base.Strings;
import common.config.tools.config.ConfigTools3;

public class CryptACL {
    private static String CRYPT_KEY_ENABLE = "crypt.response.enable";
    private static String CRYPT_KEY_DISABLE = "crypt.response.disable";
    private static String CRYPT_KEY_DISABLE_CONTENT_TYPE = "crypt.response.disable.contentType";
    private static String CRYPT_KEY_ENABLE_DEBUG = "crypt.enable.debug";

    public static boolean isDisableContentType(String contentType) {
        return ConfigTools3.getAsList((String)CRYPT_KEY_DISABLE_CONTENT_TYPE).contains(contentType);
    }

    public static boolean isCryptEnable(String api) {
        return ConfigTools3.getBoolean((String)CryptACL.getCryptKey(api), (boolean)ConfigTools3.getBoolean((String)CRYPT_KEY_ENABLE, (boolean)false));
    }

    public static boolean isResponseCryptDisable(String api) {
        return ConfigTools3.getBoolean((String)CryptACL.getCryptResKey(api), (!ConfigTools3.getBoolean((String)CRYPT_KEY_ENABLE, (boolean)false) ? 1 : 0) != 0);
    }

    public static boolean isDebugTime() {
        return ConfigTools3.getBoolean((String)CRYPT_KEY_ENABLE_DEBUG, (boolean)false);
    }

    private static String getCryptKey(String api) {
        return String.format("%s.%s", CRYPT_KEY_ENABLE, Strings.nullToEmpty((String)api));
    }

    private static String getCryptResKey(String api) {
        return String.format("%s.%s", CRYPT_KEY_DISABLE, Strings.nullToEmpty((String)api));
    }
}

