package com.valor.web.springboot.starter.goose.eus.token.autoconfiguration;

import com.valor.web.springboot.starter.goose.eus.token.interceptor.GooseEUSTokenInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnWebApplication
public class GooseEUSTokenInterceptorConfiguration extends WebMvcConfigurerAdapter {
    private Logger logger = LoggerFactory.getLogger(GooseEUSTokenInterceptorConfiguration.class);

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        InterceptorRegistration gooseApiTokenInterceptorRegistration = registry.addInterceptor(new GooseEUSTokenInterceptor());
        gooseApiTokenInterceptorRegistration.addPathPatterns("/api/*");
        gooseApiTokenInterceptorRegistration.excludePathPatterns("/api/ping/*");

        logger.info("Add Interceptor:[GooseEUSTokenInterceptor]");
    }
}
