package com.valor.web.springboot.starter.goose.eus.token.service;


import com.valor.enduser.token.validator.EnduserTokenValidator;
import com.valor.enduser.token.validator.bean.EnduserTokenValidateResult;
import com.valor.enduser.token.validator.enums.ValidateResultStatusCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooseEUSTokenService {
    private static final Logger logger = LoggerFactory.getLogger(GooseEUSTokenService.class);

    public ETokenStatus checkToken(String token, String mac, String loginId) {
        try {
            EnduserTokenValidateResult result = EnduserTokenValidator.getInstance().checkToken(token, mac, loginId);
            if (result.getStatusCode() == ValidateResultStatusCodeEnum.VALID.getStatusCode()) {
                //token valid
                return ETokenStatus.VALID;
            } else if (result.getStatusCode() == ValidateResultStatusCodeEnum.EXPIRED.getStatusCode()) {
                logger.error("Token Expired. token:{} mac:{} loginId:{}", token, mac, loginId);
                //Token expire
                return ETokenStatus.EXPIRE;
            } else {
                //token invalid
                logger.error("Token invalid. token:{} mac:{} loginId:{}", token, mac, loginId);
                return ETokenStatus.INVALID;
            }
        } catch (Exception e) {
            //token exception
            logger.error("Token Exception. token:{} mac:{} loginId:{}", token, mac, loginId);
            return ETokenStatus.EXCEPTION;
        }
    }
}
