/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.goose.eus.token.service;

import com.valor.enduser.token.validator.EnduserTokenValidator;
import com.valor.enduser.token.validator.bean.EnduserTokenValidateResult;
import com.valor.enduser.token.validator.enums.ValidateResultStatusCodeEnum;
import com.valor.web.springboot.starter.goose.eus.token.service.ETokenStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooseEUSTokenService {
    private static final Logger logger = LoggerFactory.getLogger(GooseEUSTokenService.class);

    public ETokenStatus checkToken(String token, String mac, String loginId) {
        try {
            EnduserTokenValidateResult result = EnduserTokenValidator.getInstance().checkToken(token, mac, loginId);
            if (result.getStatusCode() == ValidateResultStatusCodeEnum.VALID.getStatusCode()) {
                return ETokenStatus.VALID;
            }
            if (result.getStatusCode() == ValidateResultStatusCodeEnum.EXPIRED.getStatusCode()) {
                logger.error("Token Expired. token:{} mac:{} loginId:{}", new Object[]{token, mac, loginId});
                return ETokenStatus.EXPIRE;
            }
            logger.error("Token invalid. token:{} mac:{} loginId:{}", new Object[]{token, mac, loginId});
            return ETokenStatus.INVALID;
        }
        catch (Exception e) {
            logger.error("Token Exception. token:{} mac:{} loginId:{}", new Object[]{token, mac, loginId});
            return ETokenStatus.EXCEPTION;
        }
    }
}

