package com.valor.web.springboot.starter.goose.eus.token.service;

import com.google.common.base.MoreObjects;

public class GooseEUSTokenData {
    /**
     * 状态码
     *
     * @see ETokenStatus
     */
    private int statusCode;
    /**
     * 状态描述
     */
    private String statusDescription;
    /**
     * 过期时间，毫秒值
     */
    private long expiredTime = -1L;

    public GooseEUSTokenData() {

    }

    public GooseEUSTokenData(int code, String desc) {
        this.statusCode = code;
        this.statusDescription = desc;
    }

    public GooseEUSTokenData(ETokenStatus status) {
        this.statusCode = status.getCode();
        this.statusDescription = status.getMsg();
    }

    public int getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusDescription() {
        return statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public long getExpiredTime() {
        return expiredTime;
    }

    public void setExpiredTime(long expiredTime) {
        this.expiredTime = expiredTime;
    }

    @Override
    public String toString() {
        return "GooseEUSTokenData{" +
                "statusCode=" + statusCode +
                ", statusDescription='" + statusDescription + '\'' +
                ", expiredTime=" + expiredTime +
                '}';
    }
}
