package com.valor.web.springboot.starter.goose.eus.token.service;


import com.valor.enduser.token.validator.EnduserTokenValidator;
import com.valor.enduser.token.validator.bean.EnduserTokenValidateResult;
import com.valor.enduser.token.validator.enums.ValidateResultStatusCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooseEUSTokenService {
    private static final Logger logger = LoggerFactory.getLogger(GooseEUSTokenService.class);

    /**
     * 检查token是否合法
     *
     * @param token
     * @param mac
     * @param loginId
     * @return
     */
    public ETokenStatus checkToken(String token, String mac, String loginId) {
        try {
            EnduserTokenValidateResult result = EnduserTokenValidator.getInstance().checkToken(token, mac, loginId);
            if (result.getStatusCode() == ValidateResultStatusCodeEnum.VALID.getStatusCode()) {
                //token valid
                return ETokenStatus.VALID;
            } else if (result.getStatusCode() == ValidateResultStatusCodeEnum.EXPIRED.getStatusCode()) {
                logger.error("Token Expired. token:{} mac:{} loginId:{}", token, mac, loginId);
                //Token expire
                return ETokenStatus.EXPIRE;
            } else {
                //token invalid
                logger.error("Token invalid. token:{} mac:{} loginId:{}", token, mac, loginId);
                return ETokenStatus.INVALID;
            }
        } catch (Exception e) {
            //token exception
            logger.error("Token Exception. token:{} mac:{} loginId:{}", token, mac, loginId);
            return ETokenStatus.EXCEPTION;
        }
    }

    /**
     * 解析Goose EUS token
     *
     * @param token
     * @param mac
     * @param loginId
     * @return
     */
    public GooseEUSTokenData parseToken(String token, String mac, String loginId) {

        try {
            EnduserTokenValidateResult result = EnduserTokenValidator.getInstance().checkToken(token, mac, loginId);
            if (result == null) {
                logger.error("Token CANNOT parsable. token:{} mac:{} loginId:{} ", token, mac, loginId);
                return new GooseEUSTokenData(ETokenStatus.INVALID);
            }

            ETokenStatus status = convertTokenStatus(result.getStatusCode());
            GooseEUSTokenData tokenData = new GooseEUSTokenData(status);
            if (status.isSuccess()) {
                tokenData.setExpiredTime(result.getExpiredTime());
            } else {
                logger.error("Token invalid. token:{} mac:{} loginId:{} status:{} statusDesc:{} expired:{}", token, mac, loginId,
                        result.getStatusCode(), result.getStatusDescription(), result.getExpiredTime());
            }

            return tokenData;
        } catch (Exception e) {
            //token exception
            logger.error("Token parse exception. token:{} mac:{} loginId:{}", token, mac, loginId);
            return new GooseEUSTokenData(ETokenStatus.EXCEPTION);
        }
    }

    private ETokenStatus convertTokenStatus(int statusCode) {
        switch (statusCode) {
            case 100:
                //ValidateResultStatusCodeEnum.VALID
                return ETokenStatus.VALID;
            case 201:
                //ValidateResultStatusCodeEnum.MAC_MISMATCH
                return ETokenStatus.INVALID_MAC;
            case 202:
                //ValidateResultStatusCodeEnum.LOGINID_MISMATCH
                return ETokenStatus.INVALID_LOGINID;
            case 203:
                //ValidateResultStatusCodeEnum.EXPIRED
                return ETokenStatus.EXPIRE;

            default:
                return ETokenStatus.INVALID;
        }
    }

}
