package com.valor.web.springboot.starter.goose.portal.token.model;

public enum ETokenStatus {
    /**
     * Token valid
     */
    VALID(0, "Valid"),
    /**
     * Token expire
     */
    EXPIRE(1, "Token expired"),

    /**
     * Token INVALID
     */
    INVALID(2, "Token verify failed"),
    /**
     * Token exception
     */
    EXCEPTION(3, "Token verify exception");

    private int code;
    private String msg;

    ETokenStatus(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Override
    public String toString() {
        return String.format("%s:%s", code, msg);
    }

    public boolean isSuccess() {
        return code == VALID.getCode();
    }
}
