package com.valor.web.springboot.starter.goose.portal.token.service;


import com.valor.web.springboot.starter.goose.portal.token.model.TokenInfo;
import com.valor.web.springboot.starter.goose.portal.token.service.config.CacheConfig;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

public class CacheService {
    private final Logger logger = LoggerFactory.getLogger(CacheService.class);

    public CacheService() {
        logger.info("Cache enable status:", CacheConfig.cacheEnable());
    }

    /**
     * 保存token到Redis信息
     * key:vnoId:brandId:accountId value:TokenInfo
     */


    public RedissonClient getClient() {
        if (CacheConfig.cacheEnable()) {
            return RedissonCacheClient.getInstance().getRedissionClient();
        }
        return null;
    }

    public TokenInfo putToken(String key, TokenInfo value) {
        if (!CacheConfig.cacheEnable()) {
            return null;
        }

        RBucket<TokenInfo> bucket = getClient().getBucket(key);
        bucket.set(value, value.getExpireTime(), TimeUnit.MILLISECONDS);
        return bucket.get();
    }

    public TokenInfo getToken(String key) {
        if (!CacheConfig.cacheEnable()) {
            return null;
        }

        RBucket<TokenInfo> bucket = getClient().getBucket(key);
        if (bucket.isExists()) {
            TokenInfo value = bucket.get();
            return value;
        }

        return null;
    }
}
