package com.valor.web.springboot.starter.goose.portal.token.service;

import com.valor.web.springboot.starter.goose.portal.token.model.*;
import com.valor.web.springboot.starter.goose.portal.token.service.config.CacheConfig;
import common.config.tools.config.ConfigTools3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class GoosePortalTokenService {
    private Logger logger = LoggerFactory.getLogger(GoosePortalTokenService.class);

    private CacheService cacheService = new CacheService();
    private GoosePortalApi goosePortalApi = new GoosePortalApi();

    public ETokenStatus checkToken(String token, String loginId) {
        TokenInfo info = cacheService.getToken(getKey(loginId));
        //缓存中有切未过去，直接返回验证成功
        if (info != null && info.getToken().contentEquals(token) && !info.isExpire()) {
            return ETokenStatus.VALID;
        }

        //缓存中没有,远程调用api验证
        TokenInfo tokenInfo = new TokenInfo();
        ETokenStatus status = checkTokenByApi(token, loginId, tokenInfo);
        if (status.isSuccess()) {
            cacheService.putToken(getKey(loginId), tokenInfo);
        }

        return status;
    }

    private String getKey(String key) {
        return String.format("gpt:%s", key);
    }


    private ETokenStatus checkTokenByApi(String token, String loginId, TokenInfo tokenInfo) {
        UserDetailRequest request = new UserDetailRequest();
        request.setOperatorId(loginId);
        request.setToken(token);
        try {
            GooseWebApiResponse<UserDetailResponse> response = goosePortalApi.getUserDetail(request);
            if (response.getErrCode() != 0) {
                if (response.getErrCode() == GoosePortalApi.ERR_TOKEN_EXPIRE) {
                    return ETokenStatus.EXPIRE;
                }

                return ETokenStatus.INVALID;
            }

            //api 返回成功
            UserDetailResponse userDetailResponse = response.getResult();
            if (userDetailResponse == null) {
                return ETokenStatus.EXCEPTION;
            }

            if (tokenInfo == null) {
                tokenInfo = new TokenInfo(userDetailResponse.getUserId(), token, "", getTokenExpire());
            }

            tokenInfo.setToken(token);
            tokenInfo.setAccountId(userDetailResponse.getUserId());
            tokenInfo.setExpireTime(getTokenExpire());

            return ETokenStatus.VALID;

        } catch (Exception ex) {
            logger.error("Goose api invoke exception", ex);
            return ETokenStatus.EXCEPTION;
        }
    }

    private long getTokenExpire() {
        int tokenTime = ConfigTools3.getInt("token.verify.goose.portal.token.duration", 24 * 60 * 60 * 1000);
        return System.currentTimeMillis() + CacheConfig.getCacheDuration();
    }
}
