package com.valor.web.springboot.starter.goose.portal.token.service.config;

import common.config.tools.config.ConfigTools3;

import java.util.List;

public class CacheConfig {
    /**
     * token.verify.cache.redission.threads= 16
     * token.verify.cache.redission.nettyThreads= 32
     * token.verify.cache.redission.codec= "!<org.redisson.codec.MarshallingCodec> {}"
     * token.verify.cache.redission.transportMode= "NIO"
     * <p>
     * token.verify.cache.redission.cluster.idleConnectionTimeout=10000
     * token.verify.cache.redission.cluster.connectTimeout=10000
     * token.verify.cache.redission.cluster.timeout=3000
     * token.verify.cache.redission.cluster.retryAttempts=3
     * token.verify.cache.redission.cluster.retryInterval=1500
     * token.verify.cache.redission.cluster.failedSlaveReconnectionInterval= 3000
     * token.verify.cache.redission.cluster.failedSlaveCheckInterval= 60000
     * token.verify.cache.redission.cluster.password= null
     * token.verify.cache.redission.cluster.subscriptionsPerConnection= 5
     * token.verify.cache.redission.cluster.clientName= null
     * token.verify.cache.redission.cluster.loadBalancer= !<org.redisson.connection.balancer.RoundRobinLoadBalancer> {}
     * token.verify.cache.redission.cluster.subscriptionConnectionMinimumIdleSize= 1
     * token.verify.cache.redission.cluster.subscriptionConnectionPoolSize= 50
     * token.verify.cache.redission.cluster.slaveConnectionMinimumIdleSize= 24
     * token.verify.cache.redission.cluster.slaveConnectionPoolSize= 64
     * token.verify.cache.redission.cluster.masterConnectionMinimumIdleSize= 24
     * token.verify.cache.redission.cluster.masterConnectionPoolSize= 64
     * token.verify.cache.redission.cluster.readMode= "SLAVE"
     * token.verify.cache.redission.cluster.subscriptionMode= "SLAVE"
     * token.verify.cache.redission.cluster.nodeAddresses="redis=//127.0.0.1=7004"
     * token.verify.cache.redission.cluster.scanInterval= 1000
     * token.verify.cache.redission.cluster.pingConnectionInterval= 30000
     * token.verify.cache.redission.cluster.keepAlive= false
     * token.verify.cache.redission.cluster.tcpNoDelay= true
     */

    public static boolean cacheEnable() {
        return ConfigTools3.getBoolean("token.verify.cache.enable", true);
    }

    public static String codec() {
        return ConfigTools3.getString("token.verify.cache.redission.codec");
    }

    public static String transportMode() {
        return ConfigTools3.getString("token.verify.cache.redission.transportMode");
    }

    public static int threads() {
        return ConfigTools3.getInt("token.verify.cache.redission.threads");
    }

    public static int nettyThreads() {
        return ConfigTools3.getInt("token.verify.cache.redission.nettyThreads");
    }

    public static List<String> nodeAddresses() {
        return ConfigTools3.getAsList("token.verify.cache.redission.cluster.nodeAddresses");
    }

    public static String password() {
        return ConfigTools3.getString("token.verify.cache.redission.cluster.password");
    }

    public static long getCacheDuration() {
        return ConfigTools3.getInt("token.verify.goose.portal.token.duration", 24 * 60 * 60 * 1000);
    }

}
