/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.goose.portal.token.interceptor;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.valor.web.springboot.starter.goose.portal.token.model.ETokenStatus;
import com.valor.web.springboot.starter.goose.portal.token.service.GoosePortalTokenService;
import comm.base.tools.api.model.ApiBaseResponse;
import common.config.tools.config.ConfigTools3;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class GoosePortalTokenInterceptor
extends HandlerInterceptorAdapter {
    private Logger logger = LoggerFactory.getLogger(GoosePortalTokenInterceptor.class);
    public static final int ERR_TOKEN_EXPIRED = 7001001;
    public static final int ERR_TOKEN_INVALID = 7001002;
    private GoosePortalTokenService apiTokenService = new GoosePortalTokenService();
    private Gson gson = new Gson();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ETokenStatus status;
        if (this.isRequireVerifyToken(request).booleanValue() && !(status = this.verifyToken(request, response)).isSuccess()) {
            this.setErrorResponse(response, status);
            return false;
        }
        return true;
    }

    public String getToken(HttpServletRequest request) {
        return this.getParameter(request, "token");
    }

    public String getLoginId(HttpServletRequest request) {
        return this.getParameter(request, "operatorId");
    }

    public Boolean isRequireVerifyToken(HttpServletRequest request) {
        String url = request.getRequestURI();
        List excludeUrls = ConfigTools3.getAsList((String)"token.verify.goose.portal.url.exclude");
        for (String e : excludeUrls) {
            if (!url.startsWith(e)) continue;
            return false;
        }
        return true;
    }

    public ETokenStatus verifyToken(HttpServletRequest request, HttpServletResponse response) {
        String token = this.getToken(request);
        String loginId = this.getLoginId(request);
        return this.apiTokenService.checkToken(token, loginId);
    }

    private void setErrorResponse(HttpServletResponse response, ETokenStatus status) {
        if (status.isSuccess()) {
            return;
        }
        ApiBaseResponse apiResponse = new ApiBaseResponse();
        if (status == ETokenStatus.EXPIRE) {
            apiResponse.setErrCode(7001001);
            apiResponse.setMessage(String.format("Invalid Token [%s]", status.toString()));
        } else {
            apiResponse.setErrCode(7001002);
            apiResponse.setMessage(status.toString());
        }
        try {
            if (!response.isCommitted()) {
                response.resetBuffer();
            }
            response.setContentType("application/json");
            String payload = this.gson.toJson((Object)apiResponse);
            ServletOutputStream out = response.getOutputStream();
            out.write(payload.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            this.logger.info("Token verify failed!", (Throwable)e);
            response.setStatus(503);
        }
    }

    private String getParameter(HttpServletRequest request, String key) {
        String v = "";
        v = request.getHeader(key);
        if (!Strings.isNullOrEmpty((String)v)) {
            return v;
        }
        v = request.getParameter(key);
        if (!Strings.isNullOrEmpty((String)key)) {
            return v;
        }
        return "";
    }
}

