/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.goose.portal.token.service;

import com.valor.web.springboot.starter.goose.portal.token.model.TokenInfo;
import com.valor.web.springboot.starter.goose.portal.token.service.RedissonCacheClient;
import com.valor.web.springboot.starter.goose.portal.token.service.config.CacheConfig;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheService {
    private final Logger logger = LoggerFactory.getLogger(CacheService.class);

    public CacheService() {
        this.logger.info("Cache enable status:", (Object)CacheConfig.cacheEnable());
    }

    public RedissonClient getClient() {
        if (CacheConfig.cacheEnable()) {
            return RedissonCacheClient.getInstance().getRedissionClient();
        }
        return null;
    }

    public TokenInfo putToken(String key, TokenInfo value) {
        if (!CacheConfig.cacheEnable()) {
            return null;
        }
        RBucket bucket = this.getClient().getBucket(key);
        bucket.set((Object)value, value.getExpireTime(), TimeUnit.MILLISECONDS);
        return (TokenInfo)bucket.get();
    }

    public TokenInfo getToken(String key) {
        if (!CacheConfig.cacheEnable()) {
            return null;
        }
        RBucket bucket = this.getClient().getBucket(key);
        if (bucket.isExists()) {
            TokenInfo value = (TokenInfo)bucket.get();
            return value;
        }
        return null;
    }
}

