/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.goose.portal.token.service;

import com.google.common.base.Strings;
import com.valor.web.springboot.starter.goose.portal.token.model.GooseWebApiResponse;
import com.valor.web.springboot.starter.goose.portal.token.model.UserDetailRequest;
import com.valor.web.springboot.starter.goose.portal.token.model.UserDetailResponse;
import com.valor.web.springboot.starter.goose.portal.token.service.IGoosePortalApi;
import com.valor.web.springboot.starter.goose.portal.token.service.config.GooseApiConfig;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class GoosePortalApi {
    private final Logger logger = LoggerFactory.getLogger(GoosePortalApi.class);
    public static final int ERR_TOKEN_EXPIRE = 10200002;
    private Retrofit retrofit;
    private String hosts;
    private int connectTimeout = 10000;
    private int readTimeout = 10000;
    private IGoosePortalApi gooseWebApi;

    public GoosePortalApi() {
        this(GooseApiConfig.goosePortalApiHosts(), GooseApiConfig.goosePortalApiConnectTimeout(), GooseApiConfig.goosePortalApiReadTimeout());
    }

    public GoosePortalApi(String hosts) {
        this(hosts, 10000, 10000);
    }

    public GoosePortalApi(String hosts, int connectTimeout, int readTimeout) {
        this.hosts = hosts;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        if (Strings.isNullOrEmpty((String)hosts)) {
            throw new IllegalArgumentException("Goose portal api host not config");
        }
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).build();
        this.retrofit = new Retrofit.Builder().baseUrl(hosts).client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        this.gooseWebApi = (IGoosePortalApi)this.retrofit.create(IGoosePortalApi.class);
        this.logger.info("GoosePortalApi host[{}] timeout[{},{}]", new Object[]{hosts, connectTimeout, readTimeout});
    }

    public GooseWebApiResponse<UserDetailResponse> getUserDetail(UserDetailRequest request) {
        try {
            Response response = this.gooseWebApi.getUserDetailV1(request.getOperatorId(), request.getToken()).execute();
            if (response.isSuccessful()) {
                GooseWebApiResponse apiResponse = (GooseWebApiResponse)((Object)response.body());
                if (apiResponse.getErrCode() != 0) {
                    this.logger.error("Service Failed,status:{} response:{}", (Object)apiResponse.getErrCode(), (Object)apiResponse.getMessage());
                }
                return apiResponse;
            }
            this.logger.error("Http Failed,status:{} response:{}", (Object)response.code(), (Object)response.errorBody());
            return new GooseWebApiResponse<UserDetailResponse>(response.code(), String.format("Http status is not 2xx,code[%s]", response.code()));
        }
        catch (IOException e) {
            this.logger.error("Http exception", (Throwable)e);
            return new GooseWebApiResponse<UserDetailResponse>(500, String.format("Http exception[%s]", e.getMessage()));
        }
    }
}

