/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.goose.portal.token.service;

import com.valor.web.springboot.starter.goose.portal.token.model.ETokenStatus;
import com.valor.web.springboot.starter.goose.portal.token.model.GooseWebApiResponse;
import com.valor.web.springboot.starter.goose.portal.token.model.TokenInfo;
import com.valor.web.springboot.starter.goose.portal.token.model.UserDetailRequest;
import com.valor.web.springboot.starter.goose.portal.token.model.UserDetailResponse;
import com.valor.web.springboot.starter.goose.portal.token.service.CacheService;
import com.valor.web.springboot.starter.goose.portal.token.service.GoosePortalApi;
import com.valor.web.springboot.starter.goose.portal.token.service.config.CacheConfig;
import common.config.tools.config.ConfigTools3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoosePortalTokenService {
    private Logger logger = LoggerFactory.getLogger(GoosePortalTokenService.class);
    private CacheService cacheService = new CacheService();
    private GoosePortalApi goosePortalApi = new GoosePortalApi();

    public ETokenStatus checkToken(String token, String loginId) {
        TokenInfo info = this.cacheService.getToken(this.getKey(loginId));
        if (info != null && info.getToken().contentEquals(token) && !info.isExpire()) {
            return ETokenStatus.VALID;
        }
        TokenInfo tokenInfo = new TokenInfo();
        ETokenStatus status = this.checkTokenByApi(token, loginId, tokenInfo);
        if (status.isSuccess()) {
            this.cacheService.putToken(this.getKey(loginId), tokenInfo);
        }
        return status;
    }

    private String getKey(String key) {
        return String.format("gpt:%s", key);
    }

    private ETokenStatus checkTokenByApi(String token, String loginId, TokenInfo tokenInfo) {
        UserDetailRequest request = new UserDetailRequest();
        request.setOperatorId(loginId);
        request.setToken(token);
        try {
            GooseWebApiResponse<UserDetailResponse> response = this.goosePortalApi.getUserDetail(request);
            if (response.getErrCode() != 0) {
                if (response.getErrCode() == 10200002) {
                    return ETokenStatus.EXPIRE;
                }
                return ETokenStatus.INVALID;
            }
            UserDetailResponse userDetailResponse = (UserDetailResponse)response.getResult();
            if (userDetailResponse == null) {
                return ETokenStatus.EXCEPTION;
            }
            if (tokenInfo == null) {
                tokenInfo = new TokenInfo(userDetailResponse.getUserId(), token, "", this.getTokenExpire());
            }
            tokenInfo.setToken(token);
            tokenInfo.setAccountId(userDetailResponse.getUserId());
            tokenInfo.setExpireTime(this.getTokenExpire());
            return ETokenStatus.VALID;
        }
        catch (Exception ex) {
            this.logger.error("Goose api invoke exception", (Throwable)ex);
            return ETokenStatus.EXCEPTION;
        }
    }

    private long getTokenExpire() {
        int tokenTime = ConfigTools3.getInt((String)"token.verify.goose.portal.token.duration", (Integer)86400000);
        return System.currentTimeMillis() + CacheConfig.getCacheDuration();
    }
}

