/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.goose.portal.token.service;

import com.google.common.base.Strings;
import com.valor.web.springboot.starter.goose.portal.token.service.config.CacheConfig;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.TransportMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonCacheClient {
    private final Logger logger = LoggerFactory.getLogger((String)"RedisClient");
    private RedissonClient client;
    private static RedissonCacheClient instance = new RedissonCacheClient();

    private RedissonCacheClient() {
    }

    public static RedissonCacheClient getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RedissonClient getRedissionClient() {
        if (this.client != null && !this.client.isShutdown()) {
            return this.client;
        }
        RedissonCacheClient redissonCacheClient = this;
        synchronized (redissonCacheClient) {
            this.client = this.createRedissionClient();
        }
        return this.client;
    }

    private Config createConfig() {
        Config config = new Config();
        config.setTransportMode(this.getTransportMode(CacheConfig.transportMode()));
        this.logger.info("Cache:TransportMode={}", (Object)config.getTransportMode().name());
        ClusterServersConfig clusterConfig = config.useClusterServers();
        if (CacheConfig.nodeAddresses().isEmpty()) {
            throw new IllegalArgumentException("Redis node address not Config");
        }
        CacheConfig.nodeAddresses().forEach(e -> clusterConfig.addNodeAddress(new String[]{e}));
        if (!Strings.isNullOrEmpty((String)CacheConfig.password())) {
            clusterConfig.setPassword(CacheConfig.password());
        }
        this.logger.info("Cache:Nodes={}", (Object)clusterConfig.getNodeAddresses());
        return config;
    }

    private TransportMode getTransportMode(String transportMode) {
        if (Strings.isNullOrEmpty((String)transportMode)) {
            boolean isUnix = Strings.nullToEmpty((String)System.getProperties().getProperty("os.name")).toLowerCase().contains("linux");
            if (isUnix) {
                return TransportMode.EPOLL;
            }
            return TransportMode.NIO;
        }
        switch (transportMode) {
            case "EPOLL": {
                return TransportMode.EPOLL;
            }
            case "KQUEUE": {
                return TransportMode.KQUEUE;
            }
        }
        return TransportMode.NIO;
    }

    private RedissonClient createRedissionClient() {
        return Redisson.create((Config)this.createConfig());
    }
}

