package com.valor.web.springboot.starter.i18n.autoconfig;

import com.valor.web.springboot.starter.i18n.filter.I18nFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.ControllerAdvice;

import java.util.ArrayList;
import java.util.Arrays;

@Service
public class ValorWebI18nAutoconfig {
    private Logger logger = LoggerFactory.getLogger(ValorWebI18nAutoconfig.class);

    @Bean
    @ConditionalOnWebApplication
    public FilterRegistrationBean<I18nFilter> i18nFilter() {
        FilterRegistrationBean<I18nFilter> filterRegistrationBean = new FilterRegistrationBean<>();
        filterRegistrationBean.setFilter(new I18nFilter());
        filterRegistrationBean.setUrlPatterns(new ArrayList<>(Arrays.asList("/api/*")));
        filterRegistrationBean.setOrder(5_000);


        logger.info("Add Filter name:[{}] order[{}]","I18nFilter",filterRegistrationBean.getOrder());
        return filterRegistrationBean;
    }
}
