package com.valor.web.springboot.starter.i18n.handler;


import com.google.common.base.Strings;
import com.valor.web.springboot.starter.i18n.utils.I18nMsgBuilder;
import comm.base.tools.api.model.ApiBaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import javax.servlet.http.HttpServletRequest;


@ControllerAdvice(annotations = ValorWebI18n.class)
public class I18nResponseBodyHandler implements ResponseBodyAdvice {
    private Logger logger = LoggerFactory.getLogger(I18nResponseBodyHandler.class);

    public I18nResponseBodyHandler() {
        logger.info("***** Add I18N I18nResponseBodyHandler");
    }

    @Override
    public boolean supports(MethodParameter returnType, Class converterType) {
        return true;
    }

    @Override
    public Object beforeBodyWrite(Object body,
                                  MethodParameter returnType,
                                  MediaType selectedContentType,
                                  Class selectedConverterType,
                                  ServerHttpRequest request,
                                  ServerHttpResponse response) {
        if (body instanceof ApiBaseResponse) {
            ApiBaseResponse newBody = (ApiBaseResponse) body;
            if (newBody.getErrCode() != 0) {
                String newMsg = getI18nMsg(newBody.getErrCode(),newBody.getMessage(), ((ServletServerHttpRequest) request).getServletRequest());
                if (!Strings.isNullOrEmpty(newMsg)) {
                    newBody.setMessage(newMsg);
                    return newBody;
                }
            }
        }

        return body;
    }

    public String getLang(HttpServletRequest request) {
        String lang;
        lang = getParameter(request, "lang");
        if (!Strings.isNullOrEmpty(lang)) {
            return lang.toLowerCase();
        }

        lang = getParameter(request, "language");
        if (!Strings.isNullOrEmpty(lang)) {
            return lang.toLowerCase();
        }

        if (Strings.isNullOrEmpty(lang)){
            lang = "en";
        }

        return lang;
    }

    public String getUid(HttpServletRequest request) {
        String uid = getParameter(request, "loginId");
        if (!Strings.isNullOrEmpty(uid)) {
            return uid;
        }

        uid = getParameter(request, "mac");
        if (!Strings.isNullOrEmpty(uid)) {
            return uid;
        }

        uid = getParameter(request, "accountId");
        if (!Strings.isNullOrEmpty(uid)) {
            return uid;
        }

        return "";
    }

    public String getI18nMsg(int code, String defaultMsg, HttpServletRequest request) {
        String lang = getLang(request);
        String uid = getUid(request);
        return I18nMsgBuilder.buildMsg(lang, code, uid, defaultMsg);
    }

    private String getParameter(HttpServletRequest request, String key) {
        /**
         * 获取参数值,获取顺序:parameter->header
         */
        String v = "";
        v = request.getHeader(key);
        if (!Strings.isNullOrEmpty(v)) {
            return v;
        }

        v = request.getParameter(key);
        if (!Strings.isNullOrEmpty(key)) {
            return v;
        }

        return "";
    }
}