package com.valor.web.springboot.starter.i18n.handler;

import comm.base.tools.api.model.ApiBaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ControllerAdvice
@ValorWebI18n
public class ValorWebExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(ValorWebExceptionHandler.class);

    public ValorWebExceptionHandler() {
        logger.info("***** Add I18N ValorWebExceptionHandler");
    }

    @ExceptionHandler(value = {Exception.class})
    @ResponseBody
    public ApiBaseResponse defaultExceptionHandler(HttpServletRequest request,
                                                   HttpServletResponse response,
                                                   Exception ex) {
        String url = request.getRequestURI();
        logger.error("HTTP exception:url[{}]", url, ex);

        ApiBaseResponse rsp = new ApiBaseResponse();
        rsp.setErrCode(500);
        rsp.setMessage(String.format("Http exception[%s]", ex.getMessage()));
        return rsp;
    }
}
