package com.valor.web.springboot.starter.i18n.utils;

/**
 * 凯撒加密
 *
 * @author jijs
 */
public class CaesarCipher {
    public final static int CHARSET_SIZE = 26;
    public static int offset = 3;

    public static void offset(int offset){
        CaesarCipher.offset= offset;
    }

    public static String encode(String s) {
        return codec(s, offset);
    }

    public static String decode(String s) {
        return codec(s, 0 - offset);
    }

    public static String codec(String s, int offset) {
        String cipher = "";
        for (int i = 0; i < s.length(); i++) {
            char ch = s.charAt(i);
            // 是小写字母
            if (ch >= 'a' && ch <= 'z') {
                if (offset > 0) {
                    // 这里不光根据 offset 进行加密，还添加了该元素的下标进行加密。
                    ch += (offset + i) % CHARSET_SIZE;
                } else {
                    // 这里不光根据 offset 进行加密，还添加了该元素的下标进行加密。
                    ch += (offset - i) % CHARSET_SIZE;
                }

                if (ch < 'a') {
                    // 向左超界
                    ch += CHARSET_SIZE;
                }

                if (ch > 'z') {
                    // 向右超界
                    ch -= CHARSET_SIZE;
                }
            }
            // 是大写字母
            else if (ch >= 'A' && ch <= 'Z') {
                if (offset > 0) {
                    // 这里不光根据 offset 进行加密，还添加了该元素的下标进行加密。
                    ch += (offset + i) % CHARSET_SIZE;
                } else {
                    // 这里不光根据 offset 进行加密，还添加了该元素的下标进行加密。
                    ch += (offset - i) % CHARSET_SIZE;
                }
                if (ch < 'A') {
                    ch += CHARSET_SIZE;
                }

                if (ch > 'Z') {
                    ch -= CHARSET_SIZE;
                }

            }
            cipher += ch;
        }
        return cipher;
    }


}