package com.valor.web.springboot.starter.i18n.utils;

import com.google.common.base.Strings;
import common.config.tools.config.ConfigTools3;

import java.text.SimpleDateFormat;
import java.util.Date;

public class I18nMsgBuilder {

    public static String buildMsg(String lang, int code, String uid, String defaultMsg) {
        String msg = ConfigTools3.getI18nString(lang, String.valueOf(code));
        if (Strings.isNullOrEmpty(msg)) {
            msg = defaultMsg;
        }
        String uidStr = "*";
        if (!Strings.isNullOrEmpty(uid)) {
            uidStr = Base62.createInstance().encode(CaesarCipher.encode(uid));
        }

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String tsStr = Base62.createInstance().encode(simpleDateFormat.format(new Date()));

        return String.format("%s[%s.%s.%s]", msg, uidStr, tsStr, code);
    }
}
