/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.i18n.filter;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.valor.web.springboot.starter.i18n.utils.I18nMsgBuilder;
import com.valor.web.utils.wrapper.WebResponseWrapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class I18nFilter
extends OncePerRequestFilter {
    private Logger logger = LoggerFactory.getLogger((String)"I18nFilter");
    private static JsonParser gsonParser = new JsonParser();
    public static final String NAME_ERR_CODE = "errCode";
    public static final String NAME_MESSAGE = "message";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        WebResponseWrapper wrapper = new WebResponseWrapper(response);
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
            byte[] contentByte = wrapper.getContentAsByteArray();
            if (contentByte.length > 0) {
                String content = new String(contentByte);
                this.i18nContent(content, request, (HttpServletResponse)wrapper);
            }
        }
        finally {
            wrapper.copyBodyToResponse();
        }
    }

    private void i18nContent(String content, HttpServletRequest request, HttpServletResponse response) {
        try {
            String i18nMsg;
            JsonElement element = gsonParser.parse(content);
            if (element.isJsonNull()) {
                return;
            }
            if (!element.isJsonObject()) {
                return;
            }
            JsonObject jsonObject = element.getAsJsonObject();
            if (!jsonObject.has(NAME_ERR_CODE)) {
                return;
            }
            int code = jsonObject.get(NAME_ERR_CODE).getAsInt();
            if (code == 0) {
                return;
            }
            String defaultMsg = "";
            if (jsonObject.has(NAME_MESSAGE)) {
                defaultMsg = jsonObject.get(NAME_ERR_CODE).getAsString();
            }
            if (!Strings.isNullOrEmpty((String)(i18nMsg = this.getI18nMsg(code, request, defaultMsg)))) {
                jsonObject.addProperty(NAME_MESSAGE, i18nMsg);
            }
            String newContent = jsonObject.toString();
            if (!response.isCommitted()) {
                response.resetBuffer();
            }
            response.getOutputStream().write(newContent.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getLang(HttpServletRequest request) {
        String lang = "en";
        lang = this.getParameter(request, "lang");
        if (!Strings.isNullOrEmpty((String)lang)) {
            return lang;
        }
        lang = this.getParameter(request, "language");
        if (!Strings.isNullOrEmpty((String)lang)) {
            return lang;
        }
        return "en";
    }

    public String getUid(HttpServletRequest request) {
        String uid = this.getParameter(request, "loginId");
        if (!Strings.isNullOrEmpty((String)uid)) {
            return uid;
        }
        uid = this.getParameter(request, "mac");
        if (!Strings.isNullOrEmpty((String)uid)) {
            return uid;
        }
        uid = this.getParameter(request, "accountId");
        if (!Strings.isNullOrEmpty((String)uid)) {
            return uid;
        }
        return "";
    }

    public String getI18nMsg(int code, HttpServletRequest request, String defaultMsg) {
        String lang = this.getLang(request);
        String uid = this.getUid(request);
        return I18nMsgBuilder.buildMsg(lang, code, uid, defaultMsg);
    }

    private String getParameter(HttpServletRequest request, String key) {
        HttpServletRequest httpRequest = request;
        String v = "";
        v = httpRequest.getHeader(key);
        if (!Strings.isNullOrEmpty((String)v)) {
            return v;
        }
        v = httpRequest.getParameter(key);
        if (!Strings.isNullOrEmpty((String)key)) {
            return v;
        }
        return "";
    }
}

