package com.valor.web.springboot.starter.i18n.utils;

import com.google.common.base.Strings;
import common.config.tools.config.ConfigTools3;

import java.text.SimpleDateFormat;
import java.util.Date;

public class I18nMsgBuilder {
    /**
     * 生成带用户标识的用户消息
     * @param lang:语言
     * @param code:错误码
     * @param uid:用户标识
     * @param defaultMsg:默认消息
     * @return
     */
    public static String buildMsgWithUid(String lang, int code, String uid, String defaultMsg) {
        String msg = ConfigTools3.getI18nString(lang, String.valueOf(code));
        if (Strings.isNullOrEmpty(msg)) {
            msg = defaultMsg;
        }
        String uidStr = "*";
        if (!Strings.isNullOrEmpty(uid)) {
            uidStr = Base62.createInstance().encode(CaesarCipher.encode(uid));
        }

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String tsStr = Base62.createInstance().encode(simpleDateFormat.format(new Date()));

        return String.format("%s[%s.%s.%s]", msg, uidStr, tsStr, code);
    }

    public static String buildMsg(String lang, int code, String defaultMsg) {
        String msg = ConfigTools3.getI18nString(lang, String.valueOf(code));
        if (Strings.isNullOrEmpty(msg)) {
            msg = defaultMsg;
        }

        return String.format("%s[%s]", msg, code);
    }

}
