/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.i18n.autoconfig;

import com.valor.web.springboot.starter.i18n.filter.I18nFilter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;

@Service
public class ValorWebI18nAutoconfig {
    private Logger logger = LoggerFactory.getLogger(ValorWebI18nAutoconfig.class);

    @Bean
    @ConditionalOnWebApplication
    public FilterRegistrationBean<I18nFilter> i18nFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new I18nFilter());
        filterRegistrationBean.setUrlPatterns(new ArrayList<String>(Arrays.asList("/api/*")));
        filterRegistrationBean.setOrder(5000);
        this.logger.info("Add Filter name:[{}] order[{}]", (Object)"I18nFilter", (Object)filterRegistrationBean.getOrder());
        return filterRegistrationBean;
    }
}

