/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.i18n.handler;

import com.google.common.base.Strings;
import com.valor.web.springboot.starter.i18n.handler.I18nConfig;
import com.valor.web.springboot.starter.i18n.handler.ValorWebI18n;
import com.valor.web.springboot.starter.i18n.utils.I18nMsgBuilder;
import comm.base.tools.api.model.ApiBaseResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice(annotations={ValorWebI18n.class})
public class I18nResponseBodyHandler
implements ResponseBodyAdvice {
    private Logger logger = LoggerFactory.getLogger(I18nResponseBodyHandler.class);

    public I18nResponseBodyHandler() {
        this.logger.info("***** Add I18N I18nResponseBodyHandler");
    }

    public boolean supports(MethodParameter returnType, Class converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        String newMsg;
        ApiBaseResponse newBody;
        if (body instanceof ApiBaseResponse && (newBody = (ApiBaseResponse)body).getErrCode() != 0 && !Strings.isNullOrEmpty((String)(newMsg = this.getI18nMsg(newBody.getErrCode(), newBody.getMessage(), ((ServletServerHttpRequest)request).getServletRequest())))) {
            newBody.setMessage(newMsg);
            return newBody;
        }
        return body;
    }

    public String getLang(HttpServletRequest request) {
        String lang = this.getParameter(request, "lang");
        if (!Strings.isNullOrEmpty((String)lang)) {
            return lang.toLowerCase();
        }
        lang = this.getParameter(request, "language");
        if (!Strings.isNullOrEmpty((String)lang)) {
            return lang.toLowerCase();
        }
        if (Strings.isNullOrEmpty((String)lang)) {
            lang = "en";
        }
        return lang;
    }

    public String getUid(HttpServletRequest request) {
        String uid = this.getParameter(request, "loginId");
        if (!Strings.isNullOrEmpty((String)uid)) {
            return uid;
        }
        uid = this.getParameter(request, "mac");
        if (!Strings.isNullOrEmpty((String)uid)) {
            return uid;
        }
        uid = this.getParameter(request, "accountId");
        if (!Strings.isNullOrEmpty((String)uid)) {
            return uid;
        }
        return "";
    }

    public String getI18nMsg(int code, String defaultMsg, HttpServletRequest request) {
        String lang = this.getLang(request);
        if (I18nConfig.msgContainUid()) {
            return I18nMsgBuilder.buildMsgWithUid(lang, code, this.getUid(request), defaultMsg);
        }
        return I18nMsgBuilder.buildMsg(lang, code, defaultMsg);
    }

    private String getParameter(HttpServletRequest request, String key) {
        String v = "";
        v = request.getHeader(key);
        if (!Strings.isNullOrEmpty((String)v)) {
            return v;
        }
        v = request.getParameter(key);
        if (!Strings.isNullOrEmpty((String)key)) {
            return v;
        }
        return "";
    }
}

