/*
 * Decompiled with CFR 0.152.
 */
package com.valor.web.springboot.starter.i18n.utils;

import com.google.common.base.Strings;
import com.valor.web.springboot.starter.i18n.utils.Base62;
import com.valor.web.springboot.starter.i18n.utils.CaesarCipher;
import common.config.tools.config.ConfigTools3;
import java.text.SimpleDateFormat;
import java.util.Date;

public class I18nMsgBuilder {
    public static String buildMsgWithUid(String lang, int code, String uid, String defaultMsg) {
        String msg = ConfigTools3.getI18nString((String)lang, (String)String.valueOf(code));
        if (Strings.isNullOrEmpty((String)msg)) {
            msg = defaultMsg;
        }
        String uidStr = "*";
        if (!Strings.isNullOrEmpty((String)uid)) {
            uidStr = Base62.createInstance().encode(CaesarCipher.encode(uid));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String tsStr = Base62.createInstance().encode(simpleDateFormat.format(new Date()));
        return String.format("%s[%s.%s.%s]", msg, uidStr, tsStr, code);
    }

    public static String buildMsg(String lang, int code, String defaultMsg) {
        String msg = ConfigTools3.getI18nString((String)lang, (String)String.valueOf(code));
        if (Strings.isNullOrEmpty((String)msg)) {
            msg = defaultMsg;
        }
        return String.format("%s[%s]", msg, code);
    }
}

