package com.valor.web.utils.wrapper;

import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class ServletOutputStreamWrapper extends ServletOutputStream {

    private DataOutputStream stream;
    private WriteListener writeListener;

    public ServletOutputStreamWrapper(OutputStream output) {
        stream = new DataOutputStream(output);
    }

    @Override
    public void write(int b) throws IOException {
        stream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        stream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        stream.write(b, off, len);
    }

    @Override
    public boolean isReady() {
        // Not sure if this is correct
        return Boolean.TRUE;
    }

    @Override
    public void setWriteListener(WriteListener wl) {
        this.writeListener = wl;
    }

    public WriteListener getWriteListener() {
        return writeListener;
    }
}