/*
 * Decompiled with CFR 0.152.
 */
package com.valor.gray.feignextension.header;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class FeignHeaderInterceptor
implements RequestInterceptor {
    private static final Logger logger = LogManager.getLogger(FeignHeaderInterceptor.class);
    @Value(value="#{'${header.names}'.split(',')}")
    private List<String> headerNameList;

    public void apply(RequestTemplate template) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            logger.error("[feign extension] header pass failed: RequestContextHolder.getRequestAttributes() is null");
            return;
        }
        HttpServletRequest oldRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        this.passHeader(oldRequest, template);
    }

    private void passHeader(HttpServletRequest oldRequest, RequestTemplate template) {
        for (String headerName : this.headerNameList) {
            String headerValue = oldRequest.getHeader(headerName);
            if (StringUtils.isEmpty((CharSequence)headerValue)) {
                logger.debug(String.format("[feign extension] header ignore: target header value is empty, headerName = %s", headerName));
                continue;
            }
            logger.debug(String.format("[feign extension] header ignore: target header value is empty, headerName = %s", headerName));
            template.header(headerName, new String[]{headerValue});
        }
    }
}

